<?php
class Router {
    protected $controllers = [];
    protected $currentController = 'AuthController';
    protected $currentMethod = 'login';
    protected $params = [];

    public function __construct() {
        $url = $this->getUrl();

        if (isset($url[0]) && file_exists(__DIR__ . '/../app/controllers/' . ucfirst($url[0]) . 'Controller.php')) {
            $this->currentController = ucfirst($url[0]) . 'Controller';
            unset($url[0]);
        }

        $controllerPath = __DIR__ . '/../app/controllers/' . $this->currentController . '.php';
        
        if (!file_exists($controllerPath)) {
            require_once __DIR__ . '/../app/views/errors/404.php';
            exit;
        }

        require_once $controllerPath;
        
        if (!class_exists($this->currentController)) {
            require_once __DIR__ . '/../app/views/errors/500.php';
            exit;
        }

        $this->currentController = new $this->currentController;

        if (isset($url[1])) {
            if (method_exists($this->currentController, $url[1])) {
                $this->currentMethod = $url[1];
                unset($url[1]);
            } else {
                require_once __DIR__ . '/../app/views/errors/404.php';
                exit;
            }
        }

        $this->params = $url ? array_values($url) : [];
        
        try {
            call_user_func_array([$this->currentController, $this->currentMethod], $this->params);
        } catch (Exception $e) {
            error_log($e->getMessage());
            require_once __DIR__ . '/../app/views/errors/500.php';
            exit;
        }
    }

    public function getUrl() {
        if (isset($_GET['url'])) {
            return explode('/', filter_var(rtrim($_GET['url'], '/'), FILTER_SANITIZE_URL));
        }
        return [];
    }
}