<?php
session_start();

class Auth {
    public static function isLoggedIn() {
        return isset($_SESSION['user_id']);
    }

    public static function user() {
        if (!self::isLoggedIn()) return null;
        return $_SESSION['user'];
    }

    public static function login($user) {
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['user'] = $user;
        $_SESSION['csrf_token'] = bin2hex(random_bytes(32)); // Generate CSRF Token
    }

    public static function logout() {
        session_destroy();
        header("Location: /sms/public/login");
        exit;
    }

    public static function checkRole($allowedRoles) {
        if (!self::isLoggedIn()) {
            header("Location: /sms/public/login");
            exit;
        }
        
        $user = self::user();
        if (!in_array($user['role_name'], $allowedRoles)) {
            die("Access Denied: You do not have permission to view this page.");
        }
    }

    public static function csrfToken() {
        return $_SESSION['csrf_token'] ?? '';
    }

    public static function validateCsrf($token) {
        if (!isset($_SESSION['csrf_token']) || $token !== $_SESSION['csrf_token']) {
            die("CSRF Validation Failed");
        }
    }
}