<?php
// Security Configuration for Production

// Session Security
ini_set('session.cookie_httponly', 1);
ini_set('session.cookie_secure', 1); // Only if HTTPS
ini_set('session.use_strict_mode', 1);
ini_set('session.cookie_samesite', 'Strict');

// Error Handling (Disable in production)
ini_set('display_errors', 0);
ini_set('display_startup_errors', 0);
error_reporting(E_ALL);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/../storage/logs/error.log');

// Security Headers
header('X-Frame-Options: DENY');
header('X-Content-Type-Options: nosniff');
header('X-XSS-Protection: 1; mode=block');
header('Referrer-Policy: strict-origin-when-cross-origin');

// Input Sanitization Helper
function sanitize($data) {
    return htmlspecialchars(trim($data), ENT_QUOTES, 'UTF-8');
}

// Rate Limiting (Simple file-based)
function checkRateLimit($action, $limit = 5, $time = 300) {
    $file = __DIR__ . '/../storage/logs/ratelimit_' . $action . '.log';
    $ips = file_exists($file) ? file($file) : [];
    $ip = $_SERVER['REMOTE_ADDR'];
    $now = time();
    
    $valid = array_filter($ips, function($t) use ($now, $time) {
        return ($now - trim($t)) < $time;
    });
    
    if (count($valid) >= $limit) {
        return false; // Rate limited
    }
    
    $valid[] = $now;
    file_put_contents($file, implode("\n", $valid));
    return true;
}