<?php
/**
 * General Application Configuration
 */

// Application Settings
define('APP_NAME', 'School Management System');
define('APP_VERSION', '1.0.0');
define('APP_URL', 'http://localhost/sms/public');
define('TIMEZONE', 'UTC');

// Set Timezone
date_default_timezone_set(TIMEZONE);

// File Upload Settings
define('UPLOAD_MAX_SIZE', 5242880); // 5MB
define('ALLOWED_EXTENSIONS', ['jpg', 'jpeg', 'png', 'pdf', 'doc', 'docx']);
define('UPLOAD_PATH', __DIR__ . '/../storage/uploads/');

// Pagination Settings
define('RECORDS_PER_PAGE', 20);

// Session Settings
define('SESSION_LIFETIME', 3600); // 1 hour

// Security Settings
define('HASH_COST', 10);
define('CSRF_TOKEN_NAME', 'csrf_token');

// Mail Settings (Configure for production)
define('MAIL_HOST', 'smtp.gmail.com');
define('MAIL_PORT', 587);
define('MAIL_USERNAME', '');
define('MAIL_PASSWORD', '');
define('MAIL_FROM', 'noreply@school.com');
define('MAIL_FROM_NAME', 'School SMS');

// Development Mode
define('DEBUG_MODE', true); // Set to false in production

// Error Display
if (DEBUG_MODE) {
    ini_set('display_errors', 1);
    ini_set('display_startup_errors', 1);
    error_reporting(E_ALL);
} else {
    ini_set('display_errors', 0);
    error_reporting(0);
}