<?php 
/**
 * View Single User Details
 */
$page_title = "User Details";
require_once __DIR__ . '/../includes/header.php'; 
?>

<div class="row">
    <div class="col-md-8">
        <div class="card shadow mb-4">
            <div class="card-header bg-primary text-white">
                <h4 class="mb-0"><i class="bi bi-person"></i> User Information</h4>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <strong>Username:</strong><br>
                        <?= htmlspecialchars($user['username']) ?>
                    </div>
                    <div class="col-md-6 mb-3">
                        <strong>Full Name:</strong><br>
                        <?= htmlspecialchars($user['full_name']) ?>
                    </div>
                    <div class="col-md-6 mb-3">
                        <strong>Email:</strong><br>
                        <?= htmlspecialchars($user['email']) ?>
                    </div>
                    <div class="col-md-6 mb-3">
                        <strong>Role:</strong><br>
                        <span class="badge bg-info"><?= htmlspecialchars($user['role_name']) ?></span>
                    </div>
                    <div class="col-md-6 mb-3">
                        <strong>Status:</strong><br>
                        <span class="badge bg-<?= $user['is_active'] ? 'success' : 'danger' ?>">
                            <?= $user['is_active'] ? 'Active' : 'Inactive' ?>
                        </span>
                    </div>
                    <div class="col-md-6 mb-3">
                        <strong>Created:</strong><br>
                        <?= date('M d, Y', strtotime($user['created_at'])) ?>
                    </div>
                    <div class="col-md-6 mb-3">
                        <strong>Last Updated:</strong><br>
                        <?= date('M d, Y', strtotime($user['updated_at'])) ?>
                    </div>
                    <div class="col-md-6 mb-3">
                        <strong>Last Login:</strong><br>
                        <?= $user['last_login'] ?? 'Never' ?>
                    </div>
                </div>
            </div>
            <div class="card-footer">
                <a href="/sms/public/user/edit/<?= $user['id'] ?>" class="btn btn-warning">Edit</a>
                <a href="/sms/public/user/toggleStatus/<?= $user['id'] ?>" class="btn btn-info text-white">
                    <?= $user['is_active'] ? 'Deactivate' : 'Activate' ?>
                </a>
                <a href="/sms/public/user/index" class="btn btn-secondary">Back to List</a>
            </div>
        </div>
    </div>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>