<?php 
$page_title = "User Management";
require_once __DIR__ . '/../includes/header.php'; 
$flash = SessionHelper::getFlash('user_msg');
?>
<div class="d-flex justify-content-between mb-4">
    <h2>User Management</h2>
    <a href="/sms/public/user/create" class="btn btn-primary">+ Add User</a>
</div>

<?php if ($flash): ?>
    <div class="alert alert-<?= $flash['type'] ?>"><?= $flash['message'] ?></div>
<?php endif; ?>

<table class="table table-striped">
    <thead>
        <tr>
            <th>ID</th>
            <th>Username</th>
            <th>Full Name</th>
            <th>Email</th>
            <th>Role</th>
            <th>Status</th>
            <th>Actions</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($users as $user): ?>
        <tr>
            <td><?= $user['id'] ?></td>
            <td><?= htmlspecialchars($user['username']) ?></td>
            <td><?= htmlspecialchars($user['full_name']) ?></td>
            <td><?= htmlspecialchars($user['email']) ?></td>
            <td><?= htmlspecialchars($user['role_name']) ?></td>
            <td>
                <span class="badge bg-<?= $user['is_active'] ? 'success' : 'danger' ?>">
                    <?= $user['is_active'] ? 'Active' : 'Inactive' ?>
                </span>
            </td>
            <td>
                <a href="/sms/public/user/edit/<?= $user['id'] ?>" class="btn btn-sm btn-warning">Edit</a>
                <a href="/sms/public/user/toggleStatus/<?= $user['id'] ?>" class="btn btn-sm btn-info">
                    <?= $user['is_active'] ? 'Deactivate' : 'Activate' ?>
                </a>
                <a href="/sms/public/user/delete/<?= $user['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">Delete</a>
            </td>
        </tr>
        <?php endforeach; ?>
    </tbody>
</table>
<?php require_once __DIR__ . '/../includes/footer.php'; ?>