<?php 
$page_title = "Vehicles";
require_once __DIR__ . '/../includes/header.php'; 
$flash = SessionHelper::getFlash('transport_msg');
$transportModel = new TransportModel();
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="bi bi-bus-front"></i> Transport Vehicles</h2>
    <div>
        <a href="/sms/public/transport/routes" class="btn btn-info text-white">
            <i class="bi bi-map"></i> Routes
        </a>
        <a href="/sms/public/transport/students" class="btn btn-success">
            <i class="bi bi-people"></i> Student Assignments
        </a>
        <a href="/sms/public/transport/createVehicle" class="btn btn-primary">
            <i class="bi bi-plus-circle"></i> Add Vehicle
        </a>
    </div>
</div>

<?php if ($flash): ?>
    <div class="alert alert-<?= $flash['type'] ?>"><?= $flash['message'] ?></div>
<?php endif; ?>

<div class="card shadow">
    <div class="card-body">
        <table class="table table-hover">
            <thead class="table-light">
                <tr>
                    <th>Vehicle No</th>
                    <th>Type</th>
                    <th>Capacity</th>
                    <th>Occupied</th>
                    <th>Available</th>
                    <th>Driver</th>
                    <th>Phone</th>
                    <th>Route</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($vehicles as $vehicle): 
                    $occupied = $transportModel->getVehicleOccupancy($vehicle['id']);
                    $available = $vehicle['capacity'] - $occupied;
                ?>
                <tr>
                    <td><strong><?= htmlspecialchars($vehicle['vehicle_no']) ?></strong></td>
                    <td><span class="badge bg-secondary"><?= $vehicle['vehicle_type'] ?></span></td>
                    <td><?= $vehicle['capacity'] ?></td>
                    <td><span class="badge bg-warning"><?= $occupied ?></span></td>
                    <td><span class="badge bg-success"><?= $available ?></span></td>
                    <td><?= htmlspecialchars($vehicle['driver_name']) ?></td>
                    <td><?= htmlspecialchars($vehicle['driver_phone']) ?></td>
                    <td><?= htmlspecialchars($vehicle['route_name']) ?></td>
                    <td>
                        <span class="badge bg-<?= $vehicle['status'] ? 'success' : 'danger' ?>">
                            <?= $vehicle['status'] ? 'Active' : 'Inactive' ?>
                        </span>
                    </td>
                    <td>
                        <a href="/sms/public/transport/editVehicle/<?= $vehicle['id'] ?>" class="btn btn-sm btn-warning">Edit</a>
                        <a href="/sms/public/transport/deleteVehicle/<?= $vehicle['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">Delete</a>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>