<?php 
$page_title = "Student Transport";
require_once __DIR__ . '/../includes/header.php'; 
$flash = SessionHelper::getFlash('transport_msg');
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="bi bi-people"></i> Student Transport Assignments</h2>
    <a href="/sms/public/transport/assign" class="btn btn-primary">
        <i class="bi bi-plus-circle"></i> Assign Student
    </a>
</div>

<?php if ($flash): ?>
    <div class="alert alert-<?= $flash['type'] ?>"><?= $flash['message'] ?></div>
<?php endif; ?>

<div class="card shadow">
    <div class="card-body">
        <table class="table table-hover">
            <thead class="table-light">
                <tr>
                    <th>Admission No</th>
                    <th>Student Name</th>
                    <th>Vehicle</th>
                    <th>Route</th>
                    <th>Pickup</th>
                    <th>Drop</th>
                    <th>Monthly Fee</th>
                    <th>Start Date</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($transports as $transport): ?>
                <tr>
                    <td><?= htmlspecialchars($transport['admission_no']) ?></td>
                    <td><?= htmlspecialchars($transport['first_name'] . ' ' . $transport['last_name']) ?></td>
                    <td><?= htmlspecialchars($transport['vehicle_no']) ?> (<?= htmlspecialchars($transport['vehicle_type']) ?>)</td>
                    <td><?= htmlspecialchars($transport['route_name']) ?></td>
                    <td><?= htmlspecialchars($transport['pickup_point']) ?></td>
                    <td><?= htmlspecialchars($transport['drop_point']) ?></td>
                    <td>$<?= number_format($transport['monthly_fee'], 2) ?></td>
                    <td><?= $transport['start_date'] ?></td>
                    <td>
                        <a href="/sms/public/transport/removeAssignment/<?= $transport['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Remove this assignment?')">Remove</a>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>