<?php 
$page_title = "Add Route";
require_once __DIR__ . '/../includes/header.php'; 
?>

<h2><i class="bi bi-plus-circle"></i> Add New Route</h2>
<form method="POST" action="/sms/public/transport/storeRoute" class="card p-4">
    <input type="hidden" name="csrf_token" value="<?= Auth::csrfToken() ?>">
    
    <div class="mb-3">
        <label>Route Name <span class="text-danger">*</span></label>
        <input type="text" name="route_name" class="form-control" placeholder="e.g., Route A, North Route" required>
    </div>
    
    <div class="row">
        <div class="col-md-6 mb-3">
            <label>Start Point</label>
            <input type="text" name="start_point" class="form-control" placeholder="Pickup location">
        </div>
        <div class="col-md-6 mb-3">
            <label>End Point</label>
            <input type="text" name="end_point" class="form-control" placeholder="Drop location">
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-4 mb-3">
            <label>Distance (km)</label>
            <input type="number" step="0.1" name="distance_km" class="form-control">
        </div>
        <div class="col-md-4 mb-3">
            <label>Estimated Time</label>
            <input type="text" name="estimated_time" class="form-control" placeholder="e.g., 45 mins">
        </div>
        <div class="col-md-4 mb-3">
            <label>Fare Amount <span class="text-danger">*</span></label>
            <input type="number" step="0.01" name="fare_amount" class="form-control" required>
        </div>
    </div>
    
    <div class="mb-3">
        <label>Status</label>
        <select name="status" class="form-select">
            <option value="1">Active</option>
            <option value="0">Inactive</option>
        </select>
    </div>
    
    <button type="submit" class="btn btn-success">Save Route</button>
    <a href="/sms/public/transport/routes" class="btn btn-secondary">Cancel</a>
</form>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>