<?php 
$page_title = "Assign Transport";
require_once __DIR__ . '/../includes/header.php'; 
?>

<h2><i class="bi bi-person-plus"></i> Assign Student to Transport</h2>
<form method="POST" action="/sms/public/transport/storeAssignment" class="card p-4">
    <input type="hidden" name="csrf_token" value="<?= Auth::csrfToken() ?>">
    
    <div class="mb-3">
        <label>Select Student <span class="text-danger">*</span></label>
        <select name="student_id" class="form-select" required>
            <option value="">-- Select Student --</option>
            <?php foreach ($students as $student): ?>
                <option value="<?= $student['id'] ?>"><?= $student['admission_no'] ?> - <?= $student['first_name'] ?> <?= $student['last_name'] ?></option>
            <?php endforeach; ?>
        </select>
    </div>
    
    <div class="row">
        <div class="col-md-6 mb-3">
            <label>Select Vehicle <span class="text-danger">*</span></label>
            <select name="vehicle_id" class="form-select" required>
                <option value="">-- Select Vehicle --</option>
                <?php foreach ($vehicles as $vehicle): ?>
                    <option value="<?= $vehicle['id'] ?>"><?= $vehicle['vehicle_no'] ?> (<?= $vehicle['capacity'] ?> seats)</option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="col-md-6 mb-3">
            <label>Select Route <span class="text-danger">*</span></label>
            <select name="route_id" class="form-select" required>
                <option value="">-- Select Route --</option>
                <?php foreach ($routes as $route): ?>
                    <option value="<?= $route['id'] ?>"><?= $route['route_name'] ?> - $<?= $route['fare_amount'] ?></option>
                <?php endforeach; ?>
            </select>
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-6 mb-3">
            <label>Pickup Point</label>
            <input type="text" name="pickup_point" class="form-control" placeholder="Where to pick student">
        </div>
        <div class="col-md-6 mb-3">
            <label>Drop Point</label>
            <input type="text" name="drop_point" class="form-control" placeholder="Where to drop student">
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-6 mb-3">
            <label>Monthly Fee <span class="text-danger">*</span></label>
            <input type="number" step="0.01" name="monthly_fee" class="form-control" required>
        </div>
        <div class="col-md-6 mb-3">
            <label>Start Date <span class="text-danger">*</span></label>
            <input type="date" name="start_date" class="form-control" required>
        </div>
    </div>
    
    <div class="mb-3">
        <label>End Date (Optional)</label>
        <input type="date" name="end_date" class="form-control">
    </div>
    
    <div class="mb-3">
        <label>Status</label>
        <select name="status" class="form-select">
            <option value="1">Active</option>
            <option value="0">Inactive</option>
        </select>
    </div>
    
    <button type="submit" class="btn btn-success">Assign Student</button>
    <a href="/sms/public/transport/students" class="btn btn-secondary">Cancel</a>
</form>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>