<?php 
/**
 * View Single Student Details
 */
$page_title = "Student Details";
require_once __DIR__ . '/../includes/header.php'; 
?>

<div class="row">
    <div class="col-md-8">
        <div class="card shadow mb-4">
            <div class="card-header bg-primary text-white">
                <h4 class="mb-0"><i class="bi bi-person"></i> Student Information</h4>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <strong>Admission Number:</strong><br>
                        <?= htmlspecialchars($student['admission_no']) ?>
                    </div>
                    <div class="col-md-6 mb-3">
                        <strong>Name:</strong><br>
                        <?= htmlspecialchars($student['first_name'] . ' ' . $student['last_name']) ?>
                    </div>
                    <div class="col-md-6 mb-3">
                        <strong>Gender:</strong><br>
                        <?= htmlspecialchars($student['gender']) ?>
                    </div>
                    <div class="col-md-6 mb-3">
                        <strong>Date of Birth:</strong><br>
                        <?= date('M d, Y', strtotime($student['dob'])) ?>
                    </div>
                    <div class="col-md-6 mb-3">
                        <strong>Class:</strong><br>
                        <?= htmlspecialchars($class['name'] ?? 'N/A') ?> - <?= htmlspecialchars($class['section'] ?? '') ?>
                    </div>
                    <div class="col-md-6 mb-3">
                        <strong>Status:</strong><br>
                        <span class="badge bg-<?= $student['status'] ? 'success' : 'danger' ?>">
                            <?= $student['status'] ? 'Active' : 'Inactive' ?>
                        </span>
                    </div>
                    <div class="col-md-6 mb-3">
                        <strong>Created:</strong><br>
                        <?= date('M d, Y', strtotime($student['created_at'])) ?>
                    </div>
                    <div class="col-md-6 mb-3">
                        <strong>Last Updated:</strong><br>
                        <?= date('M d, Y', strtotime($student['updated_at'])) ?>
                    </div>
                </div>
            </div>
            <div class="card-footer">
                <a href="/sms/public/student/edit/<?= $student['id'] ?>" class="btn btn-warning">Edit</a>
                <a href="/sms/public/student/index" class="btn btn-secondary">Back to List</a>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card shadow mb-4">
            <div class="card-header bg-info text-white">
                <h5 class="mb-0">Quick Actions</h5>
            </div>
            <div class="card-body">
                <a href="/sms/public/result/report?id=<?= $student['id'] ?>" class="btn btn-outline-primary w-100 mb-2">
                    <i class="bi bi-file-earmark-text"></i> View Report Card
                </a>
                <a href="/sms/public/medical/record/<?= $student['id'] ?>" class="btn btn-outline-danger w-100 mb-2">
                    <i class="bi bi-heart-pulse"></i> Medical Record
                </a>
                <a href="/sms/public/finance/invoices?student=<?= $student['id'] ?>" class="btn btn-outline-success w-100 mb-2">
                    <i class="bi bi-currency-dollar"></i> View Invoices
                </a>
                <a href="/sms/public/attendance/report?student_id=<?= $student['id'] ?>" class="btn btn-outline-warning w-100">
                    <i class="bi bi-calendar-check"></i> Attendance Report
                </a>
            </div>
        </div>
    </div>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>