<?php 
$page_title = "Report Card";
require_once __DIR__ . '/../includes/header.php'; 
?>
<div class="card p-4">
    <div class="text-center mb-4">
        <h2>School Report Card</h2>
        <h4><?= htmlspecialchars($student['first_name'] . ' ' . $student['last_name']) ?></h4>
        <p>Admission: <?= htmlspecialchars($student['admission_no']) ?></p>
    </div>

    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Exam</th>
                <th>Subject</th>
                <th>Marks</th>
                <th>Grade</th>
            </tr>
        </thead>
        <tbody>
            <?php 
            $total_marks = 0;
            $count = 0;
            foreach ($results as $row): 
                $grade = $this->resultModel->getGrade($row['marks_obtained']);
                $total_marks += $row['marks_obtained'];
                $count++;
            ?>
            <tr>
                <td><?= htmlspecialchars($row['exam_name']) ?></td>
                <td><?= htmlspecialchars($row['subject_name']) ?></td>
                <td><?= $row['marks_obtained'] ?></td>
                <td><?= $grade ? $grade['grade_name'] : 'N/A' ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
        <tfoot>
            <tr>
                <th colspan="2">Average</th>
                <th colspan="2"><?= $count > 0 ? round($total_marks / $count, 2) : 0 ?></th>
            </tr>
        </tfoot>
    </table>
    <button onclick="window.print()" class="btn btn-secondary">Print Report</button>
</div>
<?php require_once __DIR__ . '/../includes/footer.php'; ?>