<?php 
/**
 * Exam Results Dashboard
 */
$page_title = "Exam Results";
require_once __DIR__ . '/../includes/header.php'; 
?>

<h2><i class="bi bi-file-earmark-bar-graph"></i> Exam Results Management</h2>
<p class="text-muted mb-4">Manage student examination results and report cards</p>

<div class="row">
    <div class="col-md-4 mb-4">
        <div class="card shadow h-100">
            <div class="card-header bg-primary text-white">
                <h5 class="mb-0"><i class="bi bi-pencil"></i> Enter Marks</h5>
            </div>
            <div class="card-body text-center">
                <p class="text-muted">Record student marks for examinations</p>
                <i class="bi bi-pencil-square display-4 text-primary mb-3"></i>
                <a href="/sms/public/result/enter" class="btn btn-primary">
                    <i class="bi bi-arrow-right"></i> Go to Entry
                </a>
            </div>
        </div>
    </div>
    <div class="col-md-4 mb-4">
        <div class="card shadow h-100">
            <div class="card-header bg-success text-white">
                <h5 class="mb-0"><i class="bi bi-file-earmark-text"></i> View Reports</h5>
            </div>
            <div class="card-body text-center">
                <p class="text-muted">View and print student report cards</p>
                <i class="bi bi-file-earmark-text display-4 text-success mb-3"></i>
                <a href="/sms/public/result/report" class="btn btn-success">
                    <i class="bi bi-arrow-right"></i> View Reports
                </a>
            </div>
        </div>
    </div>
    <div class="col-md-4 mb-4">
        <div class="card shadow h-100">
            <div class="card-header bg-info text-white">
                <h5 class="mb-0"><i class="bi bi-search"></i> Search Results</h5>
            </div>
            <div class="card-body text-center">
                <p class="text-muted">Search for specific examination results</p>
                <i class="bi bi-search display-4 text-info mb-3"></i>
                <a href="/sms/public/result/search" class="btn btn-info text-white">
                    <i class="bi bi-arrow-right"></i> Search
                </a>
            </div>
        </div>
    </div>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>