<?php 
$page_title = "Enter Marks";
require_once __DIR__ . '/../includes/header.php'; 
?>
<h2>Enter Examination Marks</h2>
<div class="card p-4 mb-4">
    <div class="row">
        <div class="col-md-3">
            <label>Exam</label>
            <select id="exam_id" class="form-select">
                <?php foreach ($exams as $exam): ?>
                    <option value="<?= $exam['id'] ?>"><?= $exam['name'] ?> (<?= $exam['year'] ?>)</option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="col-md-3">
            <label>Class</label>
            <select id="class_id" class="form-select">
                <?php foreach ($classes as $class): ?>
                    <option value="<?= $class['id'] ?>"><?= $class['name'] ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="col-md-3">
            <label>Subject</label>
            <select id="subject_id" class="form-select">
                <!-- Populated via JS based on class -->
            </select>
        </div>
        <div class="col-md-3 d-flex align-items-end">
            <button onclick="loadStudents()" class="btn btn-primary w-100">Load Students</button>
        </div>
    </div>
</div>

<form method="POST" action="/sms/public/result/save" id="marksForm">
    <input type="hidden" name="csrf_token" value="<?= Auth::csrfToken() ?>">
    <input type="hidden" name="exam_id" id="form_exam_id">
    <input type="hidden" name="subject_id" id="form_subject_id">
    
    <div id="marksTable"></div>
    <button type="submit" class="btn btn-success mt-3">Save Marks</button>
</form>

<script>
// Fetch subjects when class changes
document.getElementById('class_id').addEventListener('change', function() {
    // In real app, fetch subjects via AJAX based on class_id
    // For demo, we hardcode or assume all subjects available
    let subjects = [{id:1, name:'Mathematics'}, {id:2, name:'English'}, {id:3, name:'Science'}];
    let select = document.getElementById('subject_id');
    select.innerHTML = '';
    subjects.forEach(s => {
        let opt = document.createElement('option');
        opt.value = s.id;
        opt.innerText = s.name;
        select.appendChild(opt);
    });
});

function loadStudents() {
    let exam_id = document.getElementById('exam_id').value;
    let class_id = document.getElementById('class_id').value;
    let subject_id = document.getElementById('subject_id').value;

    document.getElementById('form_exam_id').value = exam_id;
    document.getElementById('form_subject_id').value = subject_id;

    fetch(`/sms/public/result/loadMarks?exam_id=${exam_id}&class_id=${class_id}&subject_id=${subject_id}`)
    .then(res => res.json())
    .then(data => {
        let html = '<table class="table"><thead><tr><th>Admission</th><th>Name</th><th>Marks (100)</th></tr></thead><tbody>';
        data.students.forEach(s => {
            let mark = data.marks[s.id] || '';
            html += `<tr>
                <td>${s.admission_no}</td>
                <td>${s.first_name} ${s.last_name}</td>
                <td><input type="number" name="marks[${s.id}]" value="${mark}" class="form-control" min="0" max="100"></td>
            </tr>`;
        });
        html += '</tbody></table>';
        document.getElementById('marksTable').innerHTML = html;
    });
}
</script>
<?php require_once __DIR__ . '/../includes/footer.php'; ?>