<?php 
$page_title = "Parents & Guardians";
require_once __DIR__ . '/../includes/header.php'; 
$flash = SessionHelper::getFlash('parent_msg');
$parentModel = new ParentModel();
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="bi bi-people"></i> Parents & Guardians</h2>
    <div>
        <form method="GET" action="/sms/public/parent/search" class="d-inline">
            <div class="input-group">
                <input type="text" name="q" class="form-control" placeholder="Search..." value="<?= htmlspecialchars($_GET['q'] ?? '') ?>">
                <button class="btn btn-primary" type="submit">Search</button>
            </div>
        </form>
        <a href="/sms/public/parent/create" class="btn btn-primary">
            <i class="bi bi-plus-circle"></i> Add Parent
        </a>
    </div>
</div>

<?php if ($flash): ?>
    <div class="alert alert-<?= $flash['type'] ?>"><?= $flash['message'] ?></div>
<?php endif; ?>

<div class="card shadow">
    <div class="card-body">
        <table class="table table-hover">
            <thead class="table-light">
                <tr>
                    <th>ID</th>
                    <th>Name</th>
                    <th>Type</th>
                    <th>Phone</th>
                    <th>Email</th>
                    <th>Occupation</th>
                    <th>City</th>
                    <th>Children</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($parents as $parent): 
                    $children = $parentModel->getStudentsByParent($parent['id']);
                ?>
                <tr>
                    <td><?= $parent['id'] ?></td>
                    <td><strong><?= htmlspecialchars($parent['first_name'] . ' ' . $parent['last_name']) ?></strong></td>
                    <td><span class="badge bg-info"><?= $parent['guardian_type'] ?></span></td>
                    <td><?= htmlspecialchars($parent['phone_primary']) ?></td>
                    <td><?= htmlspecialchars($parent['email'] ?? '-') ?></td>
                    <td><?= htmlspecialchars($parent['occupation'] ?? '-') ?></td>
                    <td><?= htmlspecialchars($parent['city'] ?? '-') ?></td>
                    <td><span class="badge bg-primary"><?= count($children) ?></span></td>
                    <td>
                        <a href="/sms/public/parent/view/<?= $parent['id'] ?>" class="btn btn-sm btn-info text-white">View</a>
                        <a href="/sms/public/parent/edit/<?= $parent['id'] ?>" class="btn btn-sm btn-warning">Edit</a>
                        <a href="/sms/public/parent/delete/<?= $parent['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">Delete</a>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>