<?php 
$page_title = "Create Parent Portal Account";
require_once __DIR__ . '/../includes/header.php'; 
?>

<h2><i class="bi bi-person-plus"></i> Create Parent Portal Account</h2>
<div class="alert alert-info">
    <i class="bi bi-info-circle"></i> 
    This will create a login account for the parent to access the parent portal and view their children's information.
</div>

<form method="POST" action="/sms/public/parent/storeAccount" class="card p-4">
    <input type="hidden" name="csrf_token" value="<?= Auth::csrfToken() ?>">
    
    <div class="mb-3">
        <label>Select Parent/Guardian <span class="text-danger">*</span></label>
        <select name="parent_id" class="form-select" required>
            <option value="">-- Select Parent/Guardian --</option>
            <?php foreach ($parents as $parent): ?>
                <option value="<?= $parent['id'] ?>">
                    <?= $parent['first_name'] ?> <?= $parent['last_name'] ?> (<?= $parent['phone_primary'] ?>)
                </option>
            <?php endforeach; ?>
        </select>
    </div>
    
    <div class="mb-3">
        <label>Username <span class="text-danger">*</span></label>
        <input type="text" name="username" class="form-control" required>
        <small class="text-muted">This will be their login username</small>
    </div>
    
    <div class="mb-3">
        <label>Email</label>
        <input type="email" name="email" class="form-control">
    </div>
    
    <div class="mb-3">
        <label>Password <span class="text-danger">*</span></label>
        <input type="password" name="password" class="form-control" required minlength="6">
        <small class="text-muted">Minimum 6 characters</small>
    </div>
    
    <button type="submit" class="btn btn-success">Create Account</button>
    <a href="/sms/public/parent/index" class="btn btn-secondary">Cancel</a>
</form>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>