<?php 
$page_title = "Add Parent/Guardian";
require_once __DIR__ . '/../includes/header.php'; 
?>

<h2><i class="bi bi-person-plus"></i> Add New Parent/Guardian</h2>
<form method="POST" action="/sms/public/parent/store" class="card p-4">
    <input type="hidden" name="csrf_token" value="<?= Auth::csrfToken() ?>">
    
    <h5 class="mb-3">Personal Information</h5>
    <div class="row">
        <div class="col-md-4 mb-3">
            <label>Guardian Type <span class="text-danger">*</span></label>
            <select name="guardian_type" class="form-select" required>
                <option value="Father">Father</option>
                <option value="Mother">Mother</option>
                <option value="Guardian">Guardian</option>
            </select>
        </div>
        <div class="col-md-4 mb-3">
            <label>First Name <span class="text-danger">*</span></label>
            <input type="text" name="first_name" class="form-control" required>
        </div>
        <div class="col-md-4 mb-3">
            <label>Last Name <span class="text-danger">*</span></label>
            <input type="text" name="last_name" class="form-control" required>
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-4 mb-3">
            <label>ID Number</label>
            <input type="text" name="id_number" class="form-control">
        </div>
        <div class="col-md-4 mb-3">
            <label>Primary Phone <span class="text-danger">*</span></label>
            <input type="text" name="phone_primary" class="form-control" required>
        </div>
        <div class="col-md-4 mb-3">
            <label>Secondary Phone</label>
            <input type="text" name="phone_secondary" class="form-control">
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-6 mb-3">
            <label>Email</label>
            <input type="email" name="email" class="form-control">
        </div>
        <div class="col-md-6 mb-3">
            <label>Occupation</label>
            <input type="text" name="occupation" class="form-control">
        </div>
    </div>
    
    <h5 class="mb-3 mt-4">Address Information</h5>
    <div class="row">
        <div class="col-md-6 mb-3">
            <label>Address</label>
            <textarea name="address" class="form-control" rows="2"></textarea>
        </div>
        <div class="col-md-3 mb-3">
            <label>City</label>
            <input type="text" name="city" class="form-control">
        </div>
        <div class="col-md-3 mb-3">
            <label>Country</label>
            <input type="text" name="country" class="form-control" value="Kenya">
        </div>
    </div>
    
    <h5 class="mb-3 mt-4">Emergency Contact</h5>
    <div class="row">
        <div class="col-md-6 mb-3">
            <label>Emergency Contact Name</label>
            <input type="text" name="emergency_contact_name" class="form-control">
        </div>
        <div class="col-md-6 mb-3">
            <label>Emergency Contact Phone</label>
            <input type="text" name="emergency_contact_phone" class="form-control">
        </div>
    </div>
    
    <div class="mb-3">
        <label>Status</label>
        <select name="status" class="form-select">
            <option value="1">Active</option>
            <option value="0">Inactive</option>
        </select>
    </div>
    
    <button type="submit" class="btn btn-success">Save Parent/Guardian</button>
    <a href="/sms/public/parent/index" class="btn btn-secondary">Cancel</a>
</form>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>