<?php 
$page_title = "Assign Parent to Student";
require_once __DIR__ . '/../includes/header.php'; 
?>

<h2><i class="bi bi-person-plus"></i> Assign Parent/Guardian to Student</h2>
<form method="POST" action="/sms/public/parent/storeAssignment" class="card p-4">
    <input type="hidden" name="csrf_token" value="<?= Auth::csrfToken() ?>">
    
    <div class="mb-3">
        <label>Select Parent/Guardian <span class="text-danger">*</span></label>
        <select name="parent_id" class="form-select" required>
            <option value="">-- Select Parent/Guardian --</option>
            <?php foreach ($parents as $parent): ?>
                <option value="<?= $parent['id'] ?>">
                    <?= $parent['first_name'] ?> <?= $parent['last_name'] ?> (<?= $parent['phone_primary'] ?>)
                </option>
            <?php endforeach; ?>
        </select>
    </div>
    
    <div class="mb-3">
        <label>Select Student <span class="text-danger">*</span></label>
        <select name="student_id" class="form-select" required>
            <option value="">-- Select Student --</option>
            <?php foreach ($students as $student): ?>
                <option value="<?= $student['id'] ?>">
                    <?= $student['admission_no'] ?> - <?= $student['first_name'] ?> <?= $student['last_name'] ?>
                </option>
            <?php endforeach; ?>
        </select>
    </div>
    
    <div class="mb-3">
        <label>Relationship</label>
        <select name="is_primary" class="form-select">
            <option value="0">Secondary Guardian</option>
            <option value="1">Primary Guardian</option>
        </select>
        <small class="text-muted">Primary guardian receives main communications</small>
    </div>
    
    <button type="submit" class="btn btn-success">Assign</button>
    <a href="/sms/public/parent/assignments" class="btn btn-secondary">View Assignments</a>
</form>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>