<?php 
$page_title = "Inbox";
require_once __DIR__ . '/../includes/header.php'; 
?>
<div class="d-flex justify-content-between mb-4">
    <h2>Inbox</h2>
    <a href="/sms/public/message/compose" class="btn btn-primary">Compose</a>
</div>

<table class="table table-hover">
    <thead><tr><th>From</th><th>Subject</th><th>Date</th><th>Status</th><th>Action</th></tr></thead>
    <tbody>
        <?php foreach ($messages as $msg): ?>
        <tr class="<?= $msg['is_read'] ? '' : 'table-active' ?>">
            <td><?= htmlspecialchars($msg['sender_name']) ?></td>
            <td><?= htmlspecialchars($msg['subject']) ?></td>
            <td><?= $msg['created_at'] ?></td>
            <td><?= $msg['is_read'] ? '<span class="badge bg-secondary">Read</span>' : '<span class="badge bg-primary">New</span>' ?></td>
            <td><a href="/sms/public/message/read/<?= $msg['id'] ?>" class="btn btn-sm btn-info">Read</a></td>
        </tr>
        <?php endforeach; ?>
    </tbody>
</table>
<?php require_once __DIR__ . '/../includes/footer.php'; ?>