<?php 
$page_title = "Compose Message";
require_once __DIR__ . '/../includes/header.php'; 
?>
<h2>Compose Message</h2>
<form method="POST" action="/sms/public/message/send" class="card p-4">
    <input type="hidden" name="csrf_token" value="<?= Auth::csrfToken() ?>">
    <div class="mb-3">
        <label>To</label>
        <select name="receiver_id" class="form-select" required>
            <?php foreach ($users as $u): ?>
                <option value="<?= $u['id'] ?>"><?= htmlspecialchars($u['full_name']) ?> (<?= $u['username'] ?>)</option>
            <?php endforeach; ?>
        </select>
    </div>
    <div class="mb-3">
        <label>Subject</label>
        <input type="text" name="subject" class="form-control" required>
    </div>
    <div class="mb-3">
        <label>Message</label>
        <textarea name="message" class="form-control" rows="5" required></textarea>
    </div>
    <button class="btn btn-success">Send Message</button>
    <a href="/sms/public/message/inbox" class="btn btn-secondary">Cancel</a>
</form>
<?php require_once __DIR__ . '/../includes/footer.php'; ?>