<?php 
$page_title = "Add Medical Staff";
require_once __DIR__ . '/../includes/header.php'; 
?>

<h2><i class="bi bi-person-plus"></i> Add Medical Staff</h2>
<form method="POST" action="/sms/public/medical/storeStaff" class="card p-4">
    <input type="hidden" name="csrf_token" value="<?= Auth::csrfToken() ?>">
    
    <div class="row">
        <div class="col-md-6 mb-3">
            <label>Name <span class="text-danger">*</span></label>
            <input type="text" name="name" class="form-control" required>
        </div>
        <div class="col-md-6 mb-3">
            <label>Qualification</label>
            <input type="text" name="qualification" class="form-control">
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-6 mb-3">
            <label>License Number</label>
            <input type="text" name="license_number" class="form-control">
        </div>
        <div class="col-md-6 mb-3">
            <label>Specialization</label>
            <input type="text" name="specialization" class="form-control">
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-6 mb-3">
            <label>Phone</label>
            <input type="text" name="phone" class="form-control">
        </div>
        <div class="col-md-6 mb-3">
            <label>Email</label>
            <input type="email" name="email" class="form-control">
        </div>
    </div>
    
    <div class="mb-3">
        <label>Status</label>
        <select name="status" class="form-select">
            <option value="1">Active</option>
            <option value="0">Inactive</option>
        </select>
    </div>
    
    <button type="submit" class="btn btn-success">Add Staff</button>
    <a href="/sms/public/medical/staff" class="btn btn-secondary">Cancel</a>
</form>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>