<?php 
$page_title = "Medical Staff";
require_once __DIR__ . '/../includes/header.php'; 
$flash = SessionHelper::getFlash('medical_msg');
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="bi bi-person-badge"></i> Medical Staff</h2>
    <a href="/sms/public/medical/createStaff" class="btn btn-primary">
        <i class="bi bi-plus-circle"></i> Add Staff
    </a>
</div>

<?php if ($flash): ?>
    <div class="alert alert-<?= $flash['type'] ?>"><?= $flash['message'] ?></div>
<?php endif; ?>

<div class="card shadow">
    <div class="card-body">
        <table class="table table-hover">
            <thead class="table-light">
                <tr>
                    <th>Name</th>
                    <th>Qualification</th>
                    <th>License</th>
                    <th>Specialization</th>
                    <th>Phone</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($staff as $s): ?>
                <tr>
                    <td><strong><?= htmlspecialchars($s['name']) ?></strong></td>
                    <td><?= htmlspecialchars($s['qualification']) ?></td>
                    <td><code><?= htmlspecialchars($s['license_number']) ?></code></td>
                    <td><?= htmlspecialchars($s['specialization']) ?></td>
                    <td><?= htmlspecialchars($s['phone']) ?></td>
                    <td><span class="badge bg-<?= $s['status'] ? 'success' : 'danger' ?>"><?= $s['status'] ? 'Active' : 'Inactive' ?></span></td>
                    <td>
                        <a href="/sms/public/medical/editStaff/<?= $s['id'] ?>" class="btn btn-sm btn-warning">Edit</a>
                        <a href="/sms/public/medical/deleteStaff/<?= $s['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">Delete</a>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>