<?php 
$page_title = "Create Medical Record";
require_once __DIR__ . '/../includes/header.php'; 
?>

<h2><i class="bi bi-file-earmark-medical"></i> Create/Update Medical Record</h2>
<form method="POST" action="/sms/public/medical/storeRecord" class="card p-4">
    <input type="hidden" name="csrf_token" value="<?= Auth::csrfToken() ?>">
    
    <div class="mb-3">
        <label>Select Student <span class="text-danger">*</span></label>
        <select name="student_id" class="form-select" required>
            <option value="">-- Select Student --</option>
            <?php foreach ($students as $student): ?>
                <option value="<?= $student['id'] ?>"><?= $student['admission_no'] ?> - <?= $student['first_name'] ?> <?= $student['last_name'] ?></option>
            <?php endforeach; ?>
        </select>
    </div>
    
    <div class="row">
        <div class="col-md-4 mb-3">
            <label>Blood Group</label>
            <select name="blood_group" class="form-select">
                <option value="">Unknown</option>
                <option value="A+">A+</option>
                <option value="A-">A-</option>
                <option value="B+">B+</option>
                <option value="B-">B-</option>
                <option value="AB+">AB+</option>
                <option value="AB-">AB-</option>
                <option value="O+">O+</option>
                <option value="O-">O-</option>
            </select>
        </div>
        <div class="col-md-4 mb-3">
            <label>Height (cm)</label>
            <input type="number" step="0.1" name="height_cm" class="form-control">
        </div>
        <div class="col-md-4 mb-3">
            <label>Weight (kg)</label>
            <input type="number" step="0.1" name="weight_kg" class="form-control">
        </div>
    </div>
    
    <div class="mb-3">
        <label>Chronic Conditions</label>
        <textarea name="chronic_conditions" class="form-control" rows="2"></textarea>
    </div>
    
    <div class="mb-3">
        <label>Allergies</label>
        <textarea name="allergies" class="form-control" rows="2"></textarea>
    </div>
    
    <div class="mb-3">
        <label>Current Medications</label>
        <textarea name="medications" class="form-control" rows="2"></textarea>
    </div>
    
    <div class="row">
        <div class="col-md-4 mb-3">
            <label>Emergency Contact Name</label>
            <input type="text" name="emergency_contact_name" class="form-control">
        </div>
        <div class="col-md-4 mb-3">
            <label>Emergency Contact Phone</label>
            <input type="text" name="emergency_contact_phone" class="form-control">
        </div>
        <div class="col-md-4 mb-3">
            <label>Relationship</label>
            <input type="text" name="emergency_contact_relationship" class="form-control">
        </div>
    </div>
    
    <div class="mb-3">
        <label>Medical Conditions</label>
        <select name="condition_ids[]" class="form-select" multiple>
            <?php foreach ($conditions as $condition): ?>
                <option value="<?= $condition['id'] ?>"><?= $condition['condition_name'] ?></option>
            <?php endforeach; ?>
        </select>
        <small class="text-muted">Hold Ctrl/Cmd to select multiple</small>
    </div>
    
    <button type="submit" class="btn btn-success">Save Medical Record</button>
    <a href="/sms/public/medical/students" class="btn btn-secondary">Cancel</a>
</form>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>