<?php 
$page_title = "Edit Medication";
require_once __DIR__ . '/../includes/header.php'; 
?>

<h2><i class="bi bi-pencil"></i> Edit Medication</h2>
<form method="POST" action="/sms/public/medical/updateMedication/<?= $medication['id'] ?>" class="card p-4">
    <input type="hidden" name="csrf_token" value="<?= Auth::csrfToken() ?>">
    
    <div class="row">
        <div class="col-md-6 mb-3">
            <label>Medication Name</label>
            <input type="text" name="medication_name" value="<?= htmlspecialchars($medication['medication_name']) ?>" class="form-control" required>
        </div>
        <div class="col-md-6 mb-3">
            <label>Generic Name</label>
            <input type="text" name="generic_name" value="<?= htmlspecialchars($medication['generic_name']) ?>" class="form-control">
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-4 mb-3">
            <label>Category</label>
            <input type="text" name="category" value="<?= htmlspecialchars($medication['category']) ?>" class="form-control">
        </div>
        <div class="col-md-4 mb-3">
            <label>Dosage Form</label>
            <select name="dosage_form" class="form-select">
                <option value="Tablet" <?= $medication['dosage_form'] == 'Tablet' ? 'selected' : '' ?>>Tablet</option>
                <option value="Capsule" <?= $medication['dosage_form'] == 'Capsule' ? 'selected' : '' ?>>Capsule</option>
                <option value="Syrup" <?= $medication['dosage_form'] == 'Syrup' ? 'selected' : '' ?>>Syrup</option>
                <option value="Injection" <?= $medication['dosage_form'] == 'Injection' ? 'selected' : '' ?>>Injection</option>
                <option value="Cream" <?= $medication['dosage_form'] == 'Cream' ? 'selected' : '' ?>>Cream</option>
                <option value="Inhaler" <?= $medication['dosage_form'] == 'Inhaler' ? 'selected' : '' ?>>Inhaler</option>
                <option value="Other" <?= $medication['dosage_form'] == 'Other' ? 'selected' : '' ?>>Other</option>
            </select>
        </div>
        <div class="col-md-4 mb-3">
            <label>Strength</label>
            <input type="text" name="strength" value="<?= htmlspecialchars($medication['strength']) ?>" class="form-control">
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-4 mb-3">
            <label>Stock Quantity</label>
            <input type="number" name="stock_quantity" value="<?= $medication['stock_quantity'] ?>" class="form-control" required>
        </div>
        <div class="col-md-4 mb-3">
            <label>Reorder Level</label>
            <input type="number" name="reorder_level" value="<?= $medication['reorder_level'] ?>" class="form-control">
        </div>
        <div class="col-md-4 mb-3">
            <label>Unit Price</label>
            <input type="number" step="0.01" name="unit_price" value="<?= $medication['unit_price'] ?>" class="form-control">
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-6 mb-3">
            <label>Expiry Date</label>
            <input type="date" name="expiry_date" value="<?= $medication['expiry_date'] ?>" class="form-control">
        </div>
        <div class="col-md-6 mb-3">
            <label>Batch Number</label>
            <input type="text" name="batch_number" value="<?= htmlspecialchars($medication['batch_number']) ?>" class="form-control">
        </div>
    </div>
    
    <button type="submit" class="btn btn-warning">Update Medication</button>
    <a href="/sms/public/medical/medications" class="btn btn-secondary">Cancel</a>
</form>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>