<?php 
$page_title = "Inventory Log";
require_once __DIR__ . '/../includes/header.php'; 
?>

<h2><i class="bi bi-box-seam"></i> Medication Inventory Log</h2>

<form method="GET" class="card p-4 mb-4">
    <div class="row">
        <div class="col-md-8">
            <label>Filter by Medication</label>
            <select name="medication" class="form-select">
                <option value="">All Medications</option>
                <?php foreach ($medications as $med): ?>
                    <option value="<?= $med['id'] ?>" <?= ($medication_id ?? '') == $med['id'] ? 'selected' : '' ?>>
                        <?= htmlspecialchars($med['medication_name']) ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="col-md-4 d-flex align-items-end">
            <button type="submit" class="btn btn-primary w-100">Filter</button>
        </div>
    </div>
</form>

<div class="card shadow">
    <div class="card-body">
        <table class="table table-hover">
            <thead class="table-light">
                <tr>
                    <th>Date</th>
                    <th>Medication</th>
                    <th>Type</th>
                    <th>Quantity</th>
                    <th>Balance</th>
                    <th>Reference</th>
                    <th>Notes</th>
                    <th>By</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($logs as $log): ?>
                <tr>
                    <td><?= date('M d, Y h:i A', strtotime($log['created_at'])) ?></td>
                    <td><?= htmlspecialchars($log['medication_name']) ?></td>
                    <td><span class="badge bg-<?= $log['transaction_type'] == 'Received' ? 'success' : 'warning' ?>"><?= $log['transaction_type'] ?></span></td>
                    <td><?= $log['quantity'] > 0 ? '+' : '' ?><?= $log['quantity'] ?></td>
                    <td><?= $log['balance_after'] ?></td>
                    <td><code><?= htmlspecialchars($log['reference_number']) ?></code></td>
                    <td><?= htmlspecialchars($log['notes']) ?></td>
                    <td><?= htmlspecialchars($log['created_by_name']) ?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>