<?php 
$page_title = "Record Immunization";
require_once __DIR__ . '/../includes/header.php'; 
?>

<h2><i class="bi bi-plus-circle"></i> Record Immunization</h2>
<form method="POST" action="/sms/public/medical/storeImmunization" class="card p-4">
    <input type="hidden" name="csrf_token" value="<?= Auth::csrfToken() ?>">
    
    <div class="mb-3">
        <label>Select Student <span class="text-danger">*</span></label>
        <select name="student_id" class="form-select" required>
            <option value="">-- Select Student --</option>
            <?php foreach ($students as $student): ?>
                <option value="<?= $student['id'] ?>"><?= $student['admission_no'] ?> - <?= $student['first_name'] ?> <?= $student['last_name'] ?></option>
            <?php endforeach; ?>
        </select>
    </div>
    
    <div class="mb-3">
        <label>Vaccine Name <span class="text-danger">*</span></label>
        <input type="text" name="vaccine_name" class="form-control" required>
    </div>
    
    <div class="row">
        <div class="col-md-6 mb-3">
            <label>Dose Number</label>
            <input type="text" name="dose_number" class="form-control" placeholder="e.g., 1st, 2nd, Booster">
        </div>
        <div class="col-md-6 mb-3">
            <label>Administration Date <span class="text-danger">*</span></label>
            <input type="date" name="administration_date" class="form-control" value="<?= date('Y-m-d') ?>" required>
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-6 mb-3">
            <label>Next Due Date</label>
            <input type="date" name="next_due_date" class="form-control">
        </div>
        <div class="col-md-6 mb-3">
            <label>Batch Number</label>
            <input type="text" name="batch_number" class="form-control">
        </div>
    </div>
    
    <div class="mb-3">
        <label>Administered By</label>
        <input type="text" name="administered_by" class="form-control">
    </div>
    
    <div class="mb-3">
        <label>Location</label>
        <input type="text" name="location" class="form-control" placeholder="e.g., School Infirmary">
    </div>
    
    <button type="submit" class="btn btn-success">Record Immunization</button>
    <a href="/sms/public/medical/immunizations" class="btn btn-secondary">Cancel</a>
</form>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>