<?php 
/**
 * Dispense Medication to Student
 */
$page_title = "Dispense Medication";
require_once __DIR__ . '/../includes/header.php'; 
?>

<h2><i class="bi bi-capsule"></i> Dispense Medication</h2>
<div class="card p-4">
    <div class="alert alert-info">
        <strong>Student:</strong> <?= htmlspecialchars($visit['first_name'] . ' ' . $visit['last_name']) ?> 
        (<?= htmlspecialchars($visit['admission_no']) ?>)<br>
        <strong>Visit Date:</strong> <?= $visit['visit_date'] ?> <?= $visit['visit_time'] ?><br>
        <strong>Complaint:</strong> <?= htmlspecialchars($visit['complaint']) ?><br>
        <strong>Diagnosis:</strong> <?= htmlspecialchars($visit['diagnosis'] ?? 'N/A') ?>
    </div>
    
    <form method="POST" action="/sms/public/medical/storeDispense">
        <input type="hidden" name="csrf_token" value="<?= Auth::csrfToken() ?>">
        <input type="hidden" name="visit_id" value="<?= $visit['id'] ?>">
        <input type="hidden" name="student_id" value="<?= $visit['student_id'] ?>">
        
        <div class="mb-3">
            <label>Select Medication <span class="text-danger">*</span></label>
            <select name="medication_id" class="form-select" required>
                <option value="">-- Select Medication --</option>
                <?php foreach ($medications as $med): ?>
                    <option value="<?= $med['id'] ?>" <?= $med['stock_quantity'] <= 0 ? 'disabled' : '' ?>>
                        <?= htmlspecialchars($med['medication_name']) ?> 
                        (<?= $med['stock_quantity'] ?> in stock - $<?= number_format($med['unit_price'], 2) ?>)
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        
        <div class="row">
            <div class="col-md-6 mb-3">
                <label>Quantity <span class="text-danger">*</span></label>
                <input type="number" name="quantity" class="form-control" min="1" required>
            </div>
            <div class="col-md-6 mb-3">
                <label>Duration (Days)</label>
                <input type="number" name="duration_days" class="form-control" min="1">
            </div>
        </div>
        
        <div class="mb-3">
            <label>Dosage Instructions <span class="text-danger">*</span></label>
            <textarea name="dosage_instructions" class="form-control" rows="2" 
                      placeholder="e.g., Take 1 tablet twice daily after meals" required></textarea>
        </div>
        
        <div class="alert alert-warning">
            <i class="bi bi-exclamation-triangle"></i> 
            Dispensing will reduce medication stock automatically. An inventory log entry will be created.
        </div>
        
        <button type="submit" class="btn btn-success">Dispense Medication</button>
        <a href="/sms/public/medical/visits" class="btn btn-secondary">Cancel</a>
    </form>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>