<?php 
$page_title = "Medical Dashboard";
require_once __DIR__ . '/../includes/header.php'; 
?>

<h2><i class="bi bi-heart-pulse"></i> Medical/Infirmary Dashboard</h2>

<div class="row mb-4">
    <div class="col-md-3">
        <div class="card bg-primary text-white">
            <div class="card-body">
                <h5>Total Visits</h5>
                <h2><?= $stats['total_visits'] ?></h2>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-success text-white">
            <div class="card-body">
                <h5>Students with Records</h5>
                <h2><?= $stats['students_with_records'] ?></h2>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-info text-white">
            <div class="card-body">
                <h5>Visits This Month</h5>
                <h2><?= $stats['visits_this_month'] ?></h2>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-warning text-white">
            <div class="card-body">
                <h5>Active Conditions</h5>
                <h2><?= $stats['active_conditions'] ?></h2>
            </div>
        </div>
    </div>
</div>

<div class="row mb-4">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header bg-danger text-white">
                <h5 class="mb-0"><i class="bi bi-exclamation-triangle"></i> Low Stock Medications (<?= $stats['low_stock'] ?>)</h5>
            </div>
            <div class="card-body">
                <?php 
                $low_stock = $this->model->getLowStockMedications();
                if (empty($low_stock)): 
                ?>
                    <p class="text-success">All medications are well stocked!</p>
                <?php else: ?>
                    <ul class="list-group">
                        <?php foreach ($low_stock as $med): ?>
                        <li class="list-group-item d-flex justify-content-between">
                            <span><?= htmlspecialchars($med['medication_name']) ?></span>
                            <span class="badge bg-danger"><?= $med['stock_quantity'] ?> left</span>
                        </li>
                        <?php endforeach; ?>
                    </ul>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card">
            <div class="card-header bg-info text-white">
                <h5 class="mb-0"><i class="bi bi-currency-dollar"></i> Pharmacy Inventory Value</h5>
            </div>
            <div class="card-body">
                <h2 class="text-success">$<?= number_format($stats['medication_value'], 2) ?></h2>
                <p class="text-muted">Total value of all medications in stock</p>
            </div>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-header">
        <h5 class="mb-0"><i class="bi bi-clock-history"></i> Recent Medical Visits</h5>
    </div>
    <div class="card-body">
        <table class="table table-hover">
            <thead>
                <tr>
                    <th>Date</th>
                    <th>Student</th>
                    <th>Complaint</th>
                    <th>Diagnosis</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($recent_visits as $visit): ?>
                <tr>
                    <td><?= $visit['visit_date'] ?></td>
                    <td><?= htmlspecialchars($visit['first_name'] . ' ' . $visit['last_name']) ?></td>
                    <td><?= htmlspecialchars(substr($visit['complaint'], 0, 50)) ?>...</td>
                    <td><?= htmlspecialchars($visit['diagnosis'] ?? '-') ?></td>
                    <td><span class="badge bg-<?= $visit['status'] == 'Closed' ? 'success' : 'warning' ?>"><?= $visit['status'] ?></span></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        <a href="/sms/public/medical/visits" class="btn btn-primary">View All Visits</a>
    </div>
</div>

<div class="row mt-4">
    <div class="col-md-3">
        <a href="/sms/public/medical/visits" class="btn btn-outline-primary w-100 mb-2">
            <i class="bi bi-clipboard-data"></i> Medical Visits
        </a>
    </div>
    <div class="col-md-3">
        <a href="/sms/public/medical/students" class="btn btn-outline-success w-100 mb-2">
            <i class="bi bi-people"></i> Student Records
        </a>
    </div>
    <div class="col-md-3">
        <a href="/sms/public/medical/medications" class="btn btn-outline-info w-100 mb-2">
            <i class="bi bi-capsule"></i> Pharmacy
        </a>
    </div>
    <div class="col-md-3">
        <a href="/sms/public/medical/incidents" class="btn btn-outline-danger w-100 mb-2">
            <i class="bi bi-exclamation-triangle"></i> Incidents
        </a>
    </div>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>