<?php 
$page_title = "Medical Conditions";
require_once __DIR__ . '/../includes/header.php'; 
$flash = SessionHelper::getFlash('medical_msg');
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="bi bi-heart-pulse"></i> Medical Conditions</h2>
    <a href="/sms/public/medical/createCondition" class="btn btn-primary">
        <i class="bi bi-plus-circle"></i> Add Condition
    </a>
</div>

<?php if ($flash): ?>
    <div class="alert alert-<?= $flash['type'] ?>"><?= $flash['message'] ?></div>
<?php endif; ?>

<div class="card shadow">
    <div class="card-body">
        <table class="table table-hover">
            <thead class="table-light">
                <tr>
                    <th>Condition Name</th>
                    <th>Type</th>
                    <th>Description</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($conditions as $c): ?>
                <tr>
                    <td><strong><?= htmlspecialchars($c['condition_name']) ?></strong></td>
                    <td><span class="badge bg-info"><?= $c['condition_type'] ?></span></td>
                    <td><?= htmlspecialchars(substr($c['description'] ?? '', 0, 50)) ?>...</td>
                    <td><span class="badge bg-<?= $c['status'] ? 'success' : 'danger' ?>"><?= $c['status'] ? 'Active' : 'Inactive' ?></span></td>
                    <td>
                        <a href="/sms/public/medical/editCondition/<?= $c['id'] ?>" class="btn btn-sm btn-warning">Edit</a>
                        <a href="/sms/public/medical/deleteCondition/<?= $c['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">Delete</a>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>