<?php 
$page_title = "Edit Medical Condition";
require_once __DIR__ . '/../includes/header.php'; 
?>

<h2><i class="bi bi-pencil"></i> Edit Medical Condition</h2>
<form method="POST" action="/sms/public/medical/updateCondition/<?= $condition['id'] ?>" class="card p-4">
    <input type="hidden" name="csrf_token" value="<?= Auth::csrfToken() ?>">
    
    <div class="mb-3">
        <label>Condition Name</label>
        <input type="text" name="condition_name" value="<?= htmlspecialchars($condition['condition_name']) ?>" class="form-control" required>
    </div>
    
    <div class="mb-3">
        <label>Type</label>
        <select name="condition_type" class="form-select" required>
            <option value="Allergy" <?= $condition['condition_type'] == 'Allergy' ? 'selected' : '' ?>>Allergy</option>
            <option value="Chronic" <?= $condition['condition_type'] == 'Chronic' ? 'selected' : '' ?>>Chronic</option>
            <option value="Disability" <?= $condition['condition_type'] == 'Disability' ? 'selected' : '' ?>>Disability</option>
            <option value="Other" <?= $condition['condition_type'] == 'Other' ? 'selected' : '' ?>>Other</option>
        </select>
    </div>
    
    <div class="mb-3">
        <label>Description</label>
        <textarea name="description" class="form-control" rows="3"><?= htmlspecialchars($condition['description']) ?></textarea>
    </div>
    
    <div class="mb-3">
        <label>Status</label>
        <select name="status" class="form-select">
            <option value="1" <?= $condition['status'] == 1 ? 'selected' : '' ?>>Active</option>
            <option value="0" <?= $condition['status'] == 0 ? 'selected' : '' ?>>Inactive</option>
        </select>
    </div>
    
    <button type="submit" class="btn btn-warning">Update Condition</button>
    <a href="/sms/public/medical/conditions" class="btn btn-secondary">Cancel</a>
</form>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>