<?php 
$page_title = "Overdue Books";
require_once __DIR__ . '/../includes/header.php'; 
?>

<h2><i class="bi bi-exclamation-triangle"></i> Overdue Books</h2>

<?php if (empty($overdue)): ?>
    <div class="alert alert-success">
        <i class="bi bi-check-circle"></i> No overdue books! All books are returned on time.
    </div>
<?php else: ?>
    <div class="card shadow">
        <div class="card-body">
            <table class="table table-hover">
                <thead class="table-light">
                    <tr>
                        <th>Book</th>
                        <th>Student</th>
                        <th>Admission</th>
                        <th>Issue Date</th>
                        <th>Due Date</th>
                        <th>Days Overdue</th>
                        <th>Est. Fine</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($overdue as $item): ?>
                    <tr class="table-danger">
                        <td><?= htmlspecialchars($item['book_title']) ?></td>
                        <td><?= htmlspecialchars($item['first_name'] . ' ' . $item['last_name']) ?></td>
                        <td><?= htmlspecialchars($item['admission_no']) ?></td>
                        <td><?= $item['issue_date'] ?></td>
                        <td><?= $item['due_date'] ?></td>
                        <td><strong><?= $item['days_overdue'] ?> days</strong></td>
                        <td><strong>$<?= number_format($item['days_overdue'] * 10, 2) ?></strong></td>
                        <td>
                            <a href="/sms/public/library/returnBook/<?= $item['id'] ?>" class="btn btn-sm btn-success">Return</a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
<?php endif; ?>

<a href="/sms/public/library/issues" class="btn btn-secondary">Back to Issues</a>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>