<?php 
$page_title = "Book Issues";
require_once __DIR__ . '/../includes/header.php'; 
$flash = SessionHelper::getFlash('library_msg');
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="bi bi-journal-check"></i> Book Issues</h2>
    <div>
        <a href="/sms/public/library/overdue" class="btn btn-danger">
            <i class="bi bi-exclamation-triangle"></i> Overdue
        </a>
        <a href="/sms/public/library/issue" class="btn btn-primary">
            <i class="bi bi-plus-circle"></i> Issue Book
        </a>
    </div>
</div>

<?php if ($flash): ?>
    <div class="alert alert-<?= $flash['type'] ?>"><?= $flash['message'] ?></div>
<?php endif; ?>

<div class="card shadow">
    <div class="card-body">
        <table class="table table-hover">
            <thead class="table-light">
                <tr>
                    <th>Book</th>
                    <th>Student</th>
                    <th>Admission</th>
                    <th>Issue Date</th>
                    <th>Due Date</th>
                    <th>Return Date</th>
                    <th>Fine</th>
                    <th>Status</th>
                    <th>Issued By</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($issues as $issue): ?>
                <tr>
                    <td><?= htmlspecialchars($issue['book_title']) ?></td>
                    <td><?= htmlspecialchars($issue['first_name'] . ' ' . $issue['last_name']) ?></td>
                    <td><?= htmlspecialchars($issue['admission_no']) ?></td>
                    <td><?= $issue['issue_date'] ?></td>
                    <td><?= $issue['due_date'] ?></td>
                    <td><?= $issue['return_date'] ?? '-' ?></td>
                    <td>$<?= number_format($issue['fine_amount'], 2) ?></td>
                    <td>
                        <span class="badge bg-<?= $issue['status'] == 'Issued' ? 'warning' : ($issue['status'] == 'Overdue' ? 'danger' : 'success') ?>">
                            <?= $issue['status'] ?>
                        </span>
                    </td>
                    <td><?= htmlspecialchars($issue['issued_by']) ?></td>
                    <td>
                        <?php if ($issue['status'] == 'Issued' || $issue['status'] == 'Overdue'): ?>
                            <a href="/sms/public/library/returnBook/<?= $issue['id'] ?>" class="btn btn-sm btn-success">Return</a>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>