<?php 
$page_title = "Issue Book";
require_once __DIR__ . '/../includes/header.php'; 
?>

<h2><i class="bi bi-book-half"></i> Issue Book to Student</h2>
<form method="POST" action="/sms/public/library/storeIssue" class="card p-4">
    <input type="hidden" name="csrf_token" value="<?= Auth::csrfToken() ?>">
    
    <div class="mb-3">
        <label>Select Book <span class="text-danger">*</span></label>
        <select name="book_id" class="form-select" required>
            <option value="">-- Select Book --</option>
            <?php foreach ($books as $book): ?>
                <option value="<?= $book['id'] ?>" <?= $book['available_copies'] <= 0 ? 'disabled' : '' ?>>
                    <?= htmlspecialchars($book['book_title']) ?> by <?= htmlspecialchars($book['author']) ?> 
                    (<?= $book['available_copies'] ?> available)
                </option>
            <?php endforeach; ?>
        </select>
    </div>
    
    <div class="mb-3">
        <label>Select Student <span class="text-danger">*</span></label>
        <select name="student_id" class="form-select" required>
            <option value="">-- Select Student --</option>
            <?php foreach ($students as $student): ?>
                <option value="<?= $student['id'] ?>"><?= $student['admission_no'] ?> - <?= $student['first_name'] ?> <?= $student['last_name'] ?></option>
            <?php endforeach; ?>
        </select>
    </div>
    
    <div class="row">
        <div class="col-md-6 mb-3">
            <label>Issue Date <span class="text-danger">*</span></label>
            <input type="date" name="issue_date" class="form-control" value="<?= date('Y-m-d') ?>" required>
        </div>
        <div class="col-md-6 mb-3">
            <label>Due Date <span class="text-danger">*</span></label>
            <input type="date" name="due_date" class="form-control" value="<?= date('Y-m-d', strtotime('+14 days')) ?>" required>
        </div>
    </div>
    
    <div class="alert alert-info">
        <i class="bi bi-info-circle"></i> 
        Students can borrow maximum 3 books at a time. Default borrowing period is 14 days.
    </div>
    
    <button type="submit" class="btn btn-success">Issue Book</button>
    <a href="/sms/public/library/issues" class="btn btn-secondary">Cancel</a>
</form>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>