<?php 
$page_title = "Library Books";
require_once __DIR__ . '/../includes/header.php'; 
$flash = SessionHelper::getFlash('library_msg');
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="bi bi-book"></i> Library Books</h2>
    <div>
        <form method="GET" action="/sms/public/library/search" class="d-inline">
            <div class="input-group">
                <input type="text" name="q" class="form-control" placeholder="Search books..." value="<?= htmlspecialchars($_GET['q'] ?? '') ?>">
                <button class="btn btn-primary" type="submit">Search</button>
            </div>
        </form>
        <a href="/sms/public/library/createBook" class="btn btn-primary">
            <i class="bi bi-plus-circle"></i> Add Book
        </a>
    </div>
</div>

<?php if ($flash): ?>
    <div class="alert alert-<?= $flash['type'] ?>"><?= $flash['message'] ?></div>
<?php endif; ?>

<div class="card shadow">
    <div class="card-body">
        <table class="table table-hover">
            <thead class="table-light">
                <tr>
                    <th>Title</th>
                    <th>Author</th>
                    <th>ISBN</th>
                    <th>Category</th>
                    <th>Total</th>
                    <th>Available</th>
                    <th>Rack</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($books as $book): ?>
                <tr>
                    <td><strong><?= htmlspecialchars($book['book_title']) ?></strong></td>
                    <td><?= htmlspecialchars($book['author']) ?></td>
                    <td><code><?= htmlspecialchars($book['isbn']) ?></code></td>
                    <td><span class="badge bg-info"><?= htmlspecialchars($book['category']) ?></span></td>
                    <td><?= $book['total_copies'] ?></td>
                    <td>
                        <span class="badge bg-<?= $book['available_copies'] > 0 ? 'success' : 'danger' ?>">
                            <?= $book['available_copies'] ?>
                        </span>
                    </td>
                    <td><?= htmlspecialchars($book['rack_number']) ?></td>
                    <td>
                        <span class="badge bg-<?= $book['status'] ? 'success' : 'danger' ?>">
                            <?= $book['status'] ? 'Available' : 'Unavailable' ?>
                        </span>
                    </td>
                    <td>
                        <a href="/sms/public/library/editBook/<?= $book['id'] ?>" class="btn btn-sm btn-warning">Edit</a>
                        <a href="/sms/public/library/deleteBook/<?= $book['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">Delete</a>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>