<?php 
$page_title = "Edit Book";
require_once __DIR__ . '/../includes/header.php'; 
?>

<h2><i class="bi bi-pencil"></i> Edit Book</h2>
<form method="POST" action="/sms/public/library/updateBook/<?= $book['id'] ?>" class="card p-4">
    <input type="hidden" name="csrf_token" value="<?= Auth::csrfToken() ?>">
    
    <div class="row">
        <div class="col-md-8 mb-3">
            <label>Book Title</label>
            <input type="text" name="book_title" value="<?= htmlspecialchars($book['book_title']) ?>" class="form-control" required>
        </div>
        <div class="col-md-4 mb-3">
            <label>Author</label>
            <input type="text" name="author" value="<?= htmlspecialchars($book['author']) ?>" class="form-control" required>
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-4 mb-3">
            <label>ISBN</label>
            <input type="text" name="isbn" value="<?= htmlspecialchars($book['isbn']) ?>" class="form-control">
        </div>
        <div class="col-md-4 mb-3">
            <label>Publisher</label>
            <input type="text" name="publisher" value="<?= htmlspecialchars($book['publisher']) ?>" class="form-control">
        </div>
        <div class="col-md-4 mb-3">
            <label>Publish Year</label>
            <input type="text" name="publish_year" value="<?= htmlspecialchars($book['publish_year']) ?>" class="form-control">
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-4 mb-3">
            <label>Category</label>
            <select name="category" class="form-select" required>
                <option value="Mathematics" <?= $book['category'] == 'Mathematics' ? 'selected' : '' ?>>Mathematics</option>
                <option value="English" <?= $book['category'] == 'English' ? 'selected' : '' ?>>English</option>
                <option value="Science" <?= $book['category'] == 'Science' ? 'selected' : '' ?>>Science</option>
                <option value="History" <?= $book['category'] == 'History' ? 'selected' : '' ?>>History</option>
                <option value="Technology" <?= $book['category'] == 'Technology' ? 'selected' : '' ?>>Technology</option>
                <option value="Literature" <?= $book['category'] == 'Literature' ? 'selected' : '' ?>>Literature</option>
                <option value="Other" <?= $book['category'] == 'Other' ? 'selected' : '' ?>>Other</option>
            </select>
        </div>
        <div class="col-md-4 mb-3">
            <label>Total Copies</label>
            <input type="number" name="total_copies" value="<?= $book['total_copies'] ?>" class="form-control" required>
        </div>
        <div class="col-md-4 mb-3">
            <label>Available Copies</label>
            <input type="number" name="available_copies" value="<?= $book['available_copies'] ?>" class="form-control" required>
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-6 mb-3">
            <label>Rack Number</label>
            <input type="text" name="rack_number" value="<?= htmlspecialchars($book['rack_number']) ?>" class="form-control">
        </div>
        <div class="col-md-6 mb-3">
            <label>Status</label>
            <select name="status" class="form-select">
                <option value="1" <?= $book['status'] == 1 ? 'selected' : '' ?>>Available</option>
                <option value="0" <?= $book['status'] == 0 ? 'selected' : '' ?>>Unavailable</option>
            </select>
        </div>
    </div>
    
    <button type="submit" class="btn btn-warning">Update Book</button>
    <a href="/sms/public/library/index" class="btn btn-secondary">Cancel</a>
</form>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>