<?php 
$page_title = "Add Book";
require_once __DIR__ . '/../includes/header.php'; 
?>

<h2><i class="bi bi-plus-circle"></i> Add New Book</h2>
<form method="POST" action="/sms/public/library/storeBook" class="card p-4">
    <input type="hidden" name="csrf_token" value="<?= Auth::csrfToken() ?>">
    
    <div class="row">
        <div class="col-md-8 mb-3">
            <label>Book Title <span class="text-danger">*</span></label>
            <input type="text" name="book_title" class="form-control" required>
        </div>
        <div class="col-md-4 mb-3">
            <label>Author <span class="text-danger">*</span></label>
            <input type="text" name="author" class="form-control" required>
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-4 mb-3">
            <label>ISBN</label>
            <input type="text" name="isbn" class="form-control" placeholder="978-0-000000-00-0">
        </div>
        <div class="col-md-4 mb-3">
            <label>Publisher</label>
            <input type="text" name="publisher" class="form-control">
        </div>
        <div class="col-md-4 mb-3">
            <label>Publish Year</label>
            <input type="text" name="publish_year" class="form-control" placeholder="2023">
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-4 mb-3">
            <label>Category <span class="text-danger">*</span></label>
            <select name="category" class="form-select" required>
                <option value="">-- Select --</option>
                <option value="Mathematics">Mathematics</option>
                <option value="English">English</option>
                <option value="Science">Science</option>
                <option value="History">History</option>
                <option value="Technology">Technology</option>
                <option value="Literature">Literature</option>
                <option value="Other">Other</option>
            </select>
        </div>
        <div class="col-md-4 mb-3">
            <label>Total Copies <span class="text-danger">*</span></label>
            <input type="number" name="total_copies" class="form-control" value="1" required>
        </div>
        <div class="col-md-4 mb-3">
            <label>Rack Number</label>
            <input type="text" name="rack_number" class="form-control" placeholder="A1, B2, etc.">
        </div>
    </div>
    
    <div class="mb-3">
        <label>Status</label>
        <select name="status" class="form-select">
            <option value="1">Available</option>
            <option value="0">Unavailable</option>
        </select>
    </div>
    
    <button type="submit" class="btn btn-success">Add Book</button>
    <a href="/sms/public/library/index" class="btn btn-secondary">Cancel</a>
</form>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>