<?php
/**
 * Footer Include File
 * Common footer for all pages
 */
?>
    </div>
    <!-- End Main Content Container -->
    
    <!-- Footer -->
    <footer class="bg-dark text-white mt-5 py-4">
        <div class="container">
            <div class="row">
                <div class="col-md-4 mb-3">
                    <h5><i class="bi bi-mortarboard-fill"></i> School Management System</h5>
                    <p class="text-muted">Comprehensive school management solution for modern educational institutions.</p>
                </div>
                <div class="col-md-4 mb-3">
                    <h6>Quick Links</h6>
                    <ul class="list-unstyled">
                        <li><a href="/sms/public/dashboard" class="text-muted text-decoration-none">Dashboard</a></li>
                        <li><a href="/sms/public/student/index" class="text-muted text-decoration-none">Students</a></li>
                        <li><a href="/sms/public/finance/invoices" class="text-muted text-decoration-none">Finance</a></li>
                        <li><a href="/sms/public/medical/index" class="text-muted text-decoration-none">Medical</a></li>
                    </ul>
                </div>
                <div class="col-md-4 mb-3">
                    <h6>Support</h6>
                    <ul class="list-unstyled text-muted">
                        <li><i class="bi bi-envelope"></i> support@school.com</li>
                        <li><i class="bi bi-telephone"></i> +254 700 000 000</li>
                        <li><i class="bi bi-clock"></i> Mon - Fri: 8:00 AM - 5:00 PM</li>
                    </ul>
                </div>
            </div>
            <hr class="bg-secondary">
            <div class="row">
                <div class="col-md-6 text-center text-md-start">
                    <p class="mb-0 text-muted">&copy; <?= date('Y') ?> School Management System. All rights reserved.</p>
                </div>
                <div class="col-md-6 text-center text-md-end">
                    <p class="mb-0 text-muted">Version 1.0.0 | Built with Pure PHP</p>
                </div>
            </div>
        </div>
    </footer>
    
    <!-- Bootstrap 5 JS Bundle -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- Chart.js for Dashboard -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <!-- Custom JavaScript -->
    <script src="/sms/public/assets/js/main.js"></script>
    
    <!-- Page Specific Scripts -->
    <?php if (isset($page_scripts)): ?>
        <?php foreach ($page_scripts as $script): ?>
            <script src="<?= $script ?>"></script>
        <?php endforeach; ?>
    <?php endif; ?>
    
    <!-- Auto-hide Alerts -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const alerts = document.querySelectorAll('.alert:not(.alert-permanent)');
            alerts.forEach(function(alert) {
                setTimeout(function() {
                    const bsAlert = new bootstrap.Alert(alert);
                    bsAlert.close();
                }, 5000);
            });
        });
    </script>
</body>
</html>