<?php 
$page_title = "Fee Structure";
require_once __DIR__ . '/../includes/header.php'; 
?>
<h2>Define Fee Structure</h2>
<form method="POST" action="/sms/public/finance/saveStructure" class="card p-4 mb-4">
    <input type="hidden" name="csrf_token" value="<?= Auth::csrfToken() ?>">
    <div class="row">
        <div class="col-md-3 mb-3">
            <label>Class</label>
            <select name="class_id" class="form-select" required>
                <?php foreach ($classes as $c): ?><option value="<?= $c['id'] ?>"><?= $c['name'] ?></option><?php endforeach; ?>
            </select>
        </div>
        <div class="col-md-3 mb-3">
            <label>Fee Type</label>
            <select name="fee_type_id" class="form-select" required>
                <?php foreach ($feeTypes as $f): ?><option value="<?= $f['id'] ?>"><?= $f['name'] ?></option><?php endforeach; ?>
            </select>
        </div>
        <div class="col-md-3 mb-3">
            <label>Amount</label>
            <input type="number" name="amount" class="form-control" required>
        </div>
        <div class="col-md-3 mb-3">
            <label>Year</label>
            <input type="text" name="year" class="form-control" value="2023" required>
        </div>
    </div>
    <button class="btn btn-primary">Save Structure</button>
</form>
<?php require_once __DIR__ . '/../includes/footer.php'; ?>