<?php 
$page_title = "Make Payment";
require_once __DIR__ . '/../includes/header.php'; 
?>
<h2>Make Payment</h2>
<div class="alert alert-info">
    Invoice: <?= htmlspecialchars($invoice['invoice_no']) ?><br>
    Student: <?= htmlspecialchars($invoice['first_name'] . ' ' . $invoice['last_name']) ?><br>
    Total: <?= $invoice['total_amount'] ?> | Paid: <?= $invoice['paid_amount'] ?> | <strong>Balance: <?= $invoice['balance_amount'] ?></strong>
</div>

<form method="POST" action="/sms/public/finance/processPayment" class="card p-4">
    <input type="hidden" name="csrf_token" value="<?= Auth::csrfToken() ?>">
    <input type="hidden" name="invoice_id" value="<?= $invoice['id'] ?>">
    
    <div class="mb-3">
        <label>Amount to Pay</label>
        <input type="number" name="amount" class="form-control" max="<?= $invoice['balance_amount'] ?>" required>
    </div>
    <div class="mb-3">
        <label>Payment Date</label>
        <input type="date" name="payment_date" class="form-control" value="<?= date('Y-m-d') ?>" required>
    </div>
    <div class="mb-3">
        <label>Method</label>
        <select name="method" class="form-select">
            <option>Cash</option><option>Bank</option><option>MPesa</option><option>Cheque</option>
        </select>
    </div>
    <div class="mb-3">
        <label>Transaction Ref</label>
        <input type="text" name="ref" class="form-control">
    </div>
    <button class="btn btn-primary">Record Payment</button>
</form>
<?php require_once __DIR__ . '/../includes/footer.php'; ?>