<?php 
$page_title = "Generate Invoice";
require_once __DIR__ . '/../includes/header.php'; 
?>
<h2>Generate Invoice</h2>
<form method="POST" action="/sms/public/finance/generateInvoice" class="card p-4">
    <input type="hidden" name="csrf_token" value="<?= Auth::csrfToken() ?>">
    <div class="mb-3">
        <label>Select Student</label>
        <select name="student_id" class="form-select" required>
            <?php foreach ($students as $s): ?>
                <option value="<?= $s['id'] ?>"><?= $s['admission_no'] ?> - <?= $s['first_name'] ?> <?= $s['last_name'] ?></option>
            <?php endforeach; ?>
        </select>
    </div>
    <div class="mb-3">
        <label>Total Amount</label>
        <input type="number" name="total_amount" class="form-control" required>
    </div>
    <div class="mb-3">
        <label>Due Date</label>
        <input type="date" name="due_date" class="form-control" required>
    </div>
    <button class="btn btn-success">Generate Invoice</button>
</form>
<?php require_once __DIR__ . '/../includes/footer.php'; ?>