<?php 
/**
 * View Exam Details
 */
$page_title = "Exam Details";
require_once __DIR__ . '/../includes/header.php'; 
?>

<div class="row">
    <div class="col-md-8">
        <div class="card shadow mb-4">
            <div class="card-header bg-primary text-white">
                <h4 class="mb-0"><i class="bi bi-journal-check"></i> Exam Information</h4>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <strong>Exam Name:</strong><br>
                        <?= htmlspecialchars($exam['name']) ?>
                    </div>
                    <div class="col-md-6 mb-3">
                        <strong>Year:</strong><br>
                        <?= htmlspecialchars($exam['year']) ?>
                    </div>
                    <div class="col-md-6 mb-3">
                        <strong>Term:</strong><br>
                        <?= htmlspecialchars($exam['term']) ?>
                    </div>
                    <div class="col-md-6 mb-3">
                        <strong>Status:</strong><br>
                        <span class="badge bg-<?= $exam['status'] ? 'success' : 'secondary' ?>">
                            <?= $exam['status'] ? 'Active' : 'Closed' ?>
                        </span>
                    </div>
                    <div class="col-md-6 mb-3">
                        <strong>Created:</strong><br>
                        <?= date('M d, Y', strtotime($exam['created_at'])) ?>
                    </div>
                </div>
            </div>
            <div class="card-footer">
                <a href="/sms/public/exam/edit/<?= $exam['id'] ?>" class="btn btn-warning">Edit</a>
                <a href="/sms/public/exam/index" class="btn btn-secondary">Back</a>
            </div>
        </div>
    </div>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>