<?php 
$page_title = "Exams";
require_once __DIR__ . '/../includes/header.php'; 
?>
<h2>Exam List</h2>
<a href="/sms/public/exam/create" class="btn btn-primary mb-3">Create Exam</a>
<table class="table table-bordered">
    <thead><tr><th>Name</th><th>Year</th><th>Term</th><th>Status</th></tr></thead>
    <tbody>
        <?php foreach ($exams as $exam): ?>
        <tr>
            <td><?= htmlspecialchars($exam['name']) ?></td>
            <td><?= htmlspecialchars($exam['year']) ?></td>
            <td><?= htmlspecialchars($exam['term']) ?></td>
            <td><?= $exam['status'] ? 'Active' : 'Closed' ?></td>
        </tr>
        <?php endforeach; ?>
    </tbody>
</table>
<?php require_once __DIR__ . '/../includes/footer.php'; ?>