<?php 
/**
 * Maintenance Mode Page
 */
http_response_code(503);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Under Maintenance</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        .maintenance-box {
            background: white;
            padding: 3rem;
            border-radius: 15px;
            text-align: center;
            box-shadow: 0 10px 40px rgba(0,0,0,0.2);
            max-width: 500px;
        }
        .icon {
            font-size: 5rem;
            margin-bottom: 1rem;
        }
    </style>
</head>
<body>
    <div class="maintenance-box">
        <div class="icon">🔧</div>
        <h1 class="mb-3">Under Maintenance</h1>
        <p class="lead text-muted mb-4">
            We're currently performing scheduled maintenance to improve our services.
        </p>
        <p class="text-muted">
            <strong>Expected downtime:</strong> 2 hours<br>
            <strong>Started:</strong> <?= date('M d, Y h:i A') ?>
        </p>
        <p class="text-muted mb-4">
            Please check back soon. We apologize for any inconvenience.
        </p>
        <a href="/" class="btn btn-primary">Try Again</a>
    </div>
</body>
</html>