<?php 
/**
 * Classes List View
 */
$page_title = "Classes";
require_once __DIR__ . '/../includes/header.php'; 
$flash = SessionHelper::getFlash('class_msg');
$errors = SessionHelper::getFlash('class_errors');
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="bi bi-building"></i> Classes</h2>
    <a href="/sms/public/class/create" class="btn btn-primary">
        <i class="bi bi-plus-circle"></i> Add Class
    </a>
</div>

<?php if ($flash): ?>
    <div class="alert alert-<?= $flash['type'] ?> alert-dismissible fade show" role="alert">
        <?= $flash['message'] ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<?php if ($errors): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <ul class="mb-0">
            <?php foreach ($errors as $error): ?>
                <li><?= $error ?></li>
            <?php endforeach; ?>
        </ul>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<div class="card shadow">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead class="table-light">
                    <tr>
                        <th>ID</th>
                        <th>Class Name</th>
                        <th>Section</th>
                        <th>Students</th>
                        <th>Created</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($classes)): ?>
                    <tr>
                        <td colspan="6" class="text-center text-muted py-4">No classes found. Create your first class!</td>
                    </tr>
                    <?php else: ?>
                        <?php foreach ($classes as $class): 
                            $classModel = new ClassModel();
                            $count = $classModel->getStudentCount($class['id']);
                        ?>
                        <tr>
                            <td><?= $class['id'] ?></td>
                            <td><strong><?= htmlspecialchars($class['name']) ?></strong></td>
                            <td><span class="badge bg-info"><?= htmlspecialchars($class['section']) ?></span></td>
                            <td><span class="badge bg-primary"><?= $count ?> Students</span></td>
                            <td><?= date('M d, Y', strtotime($class['created_at'])) ?></td>
                            <td>
                                <div class="btn-group btn-group-sm">
                                    <a href="/sms/public/class/edit/<?= $class['id'] ?>" class="btn btn-warning" title="Edit">
                                        <i class="bi bi-pencil"></i>
                                    </a>
                                    <a href="/sms/public/class/delete/<?= $class['id'] ?>" class="btn btn-danger" 
                                       onclick="return confirm('Are you sure? This will affect all students in this class.')" title="Delete">
                                        <i class="bi bi-trash"></i>
                                    </a>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>