<?php 
$page_title = "Room Inspections";
require_once __DIR__ . '/../includes/header.php'; 
$flash = SessionHelper::getFlash('boarding_msg');
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="bi bi-clipboard-check"></i> Room Inspections</h2>
    <a href="/sms/public/boarding/createInspection" class="btn btn-primary">
        <i class="bi bi-plus-circle"></i> New Inspection
    </a>
</div>

<?php if ($flash): ?>
    <div class="alert alert-<?= $flash['type'] ?>"><?= $flash['message'] ?></div>
<?php endif; ?>

<div class="card shadow">
    <div class="card-body">
        <table class="table table-hover">
            <thead class="table-light">
                <tr>
                    <th>Hostel</th>
                    <th>Room</th>
                    <th>Inspector</th>
                    <th>Date</th>
                    <th>Cleanliness</th>
                    <th>Issues</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($inspections as $inspection): ?>
                <tr>
                    <td><?= htmlspecialchars($inspection['hostel_name']) ?></td>
                    <td><?= htmlspecialchars($inspection['room_number']) ?></td>
                    <td><?= htmlspecialchars($inspection['inspector_name']) ?></td>
                    <td><?= $inspection['inspection_date'] ?></td>
                    <td>
                        <span class="badge bg-<?= $inspection['cleanliness'] == 'Excellent' ? 'success' : ($inspection['cleanliness'] == 'Poor' ? 'danger' : 'warning') ?>">
                            <?= $inspection['cleanliness'] ?>
                        </span>
                    </td>
                    <td><?= htmlspecialchars(substr($inspection['maintenance_issues'], 0, 50)) ?><?= strlen($inspection['maintenance_issues']) > 50 ? '...' : '' ?></td>
                    <td>
                        <span class="badge bg-<?= $inspection['status'] == 'Resolved' ? 'success' : ($inspection['status'] == 'Pending' ? 'danger' : 'warning') ?>">
                            <?= $inspection['status'] ?>
                        </span>
                    </td>
                    <td>
                        <?php if ($inspection['status'] != 'Resolved'): ?>
                            <a href="/sms/public/boarding/resolveInspection/<?= $inspection['id'] ?>" class="btn btn-sm btn-success">Mark Resolved</a>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>