<?php 
$page_title = "Hostels";
require_once __DIR__ . '/../includes/header.php'; 
$flash = SessionHelper::getFlash('boarding_msg');
$boardingModel = new BoardingModel();
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="bi bi-building"></i> Hostels & Dormitories</h2>
    <div>
        <a href="/sms/public/boarding/rooms" class="btn btn-info text-white">
            <i class="bi bi-door-open"></i> Rooms
        </a>
        <a href="/sms/public/boarding/students" class="btn btn-success">
            <i class="bi bi-people"></i> Boarding Students
        </a>
        <a href="/sms/public/boarding/createHostel" class="btn btn-primary">
            <i class="bi bi-plus-circle"></i> Add Hostel
        </a>
    </div>
</div>

<?php if ($flash): ?>
    <div class="alert alert-<?= $flash['type'] ?>"><?= $flash['message'] ?></div>
<?php endif; ?>

<div class="row">
    <?php foreach ($hostels as $hostel): 
        $occupancy = $boardingModel->getHostelOccupancy($hostel['id']);
        $occupancyRate = $occupancy['capacity'] > 0 ? round(($occupancy['occupied'] / $occupancy['capacity']) * 100) : 0;
    ?>
    <div class="col-md-4 mb-4">
        <div class="card shadow h-100">
            <div class="card-header bg-<?= $hostel['type'] == 'Boys' ? 'primary' : ($hostel['type'] == 'Girls' ? 'danger' : 'info') ?> text-white">
                <h5 class="mb-0"><?= htmlspecialchars($hostel['name']) ?></h5>
            </div>
            <div class="card-body">
                <p><strong>Type:</strong> <span class="badge bg-<?= $hostel['type'] == 'Boys' ? 'primary' : ($hostel['type'] == 'Girls' ? 'danger' : 'info') ?>"><?= $hostel['type'] ?></span></p>
                <p><strong>Rooms:</strong> <?= $hostel['total_rooms'] ?></p>
                <p><strong>Capacity:</strong> <?= $hostel['total_capacity'] ?> beds</p>
                <p><strong>Occupied:</strong> <?= $occupancy['occupied'] ?? 0 ?> / <?= $occupancy['capacity'] ?? 0 ?></p>
                <div class="progress mb-3">
                    <div class="progress-bar bg-<?= $occupancyRate > 80 ? 'warning' : 'success' ?>" style="width: <?= $occupancyRate ?>%"><?= $occupancyRate ?>%</div>
                </div>
                <p><strong>Warden:</strong> <?= htmlspecialchars($hostel['warden_name']) ?></p>
                <p><strong>Phone:</strong> <?= htmlspecialchars($hostel['warden_phone']) ?></p>
                <p><strong>Status:</strong> 
                    <span class="badge bg-<?= $hostel['status'] ? 'success' : 'danger' ?>">
                        <?= $hostel['status'] ? 'Active' : 'Inactive' ?>
                    </span>
                </p>
            </div>
            <div class="card-footer">
                <a href="/sms/public/boarding/editHostel/<?= $hostel['id'] ?>" class="btn btn-sm btn-warning">Edit</a>
                <a href="/sms/public/boarding/rooms?hostel=<?= $hostel['id'] ?>" class="btn btn-sm btn-info text-white">View Rooms</a>
            </div>
        </div>
    </div>
    <?php endforeach; ?>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>