<?php 
$page_title = "Assign Boarding";
require_once __DIR__ . '/../includes/header.php'; 
?>

<h2><i class="bi bi-person-plus"></i> Assign Student to Boarding</h2>
<form method="POST" action="/sms/public/boarding/storeAssignment" class="card p-4">
    <input type="hidden" name="csrf_token" value="<?= Auth::csrfToken() ?>">
    
    <div class="mb-3">
        <label>Select Student <span class="text-danger">*</span></label>
        <select name="student_id" class="form-select" required>
            <option value="">-- Select Student --</option>
            <?php foreach ($students as $student): ?>
                <option value="<?= $student['id'] ?>"><?= $student['admission_no'] ?> - <?= $student['first_name'] ?> <?= $student['last_name'] ?></option>
            <?php endforeach; ?>
        </select>
    </div>
    
    <div class="mb-3">
        <label>Select Room <span class="text-danger">*</span></label>
        <select name="room_id" class="form-select" required>
            <option value="">-- Select Available Room --</option>
            <?php foreach ($rooms as $room): ?>
                <option value="<?= $room['id'] ?>">
                    <?= htmlspecialchars($room['hostel_name']) ?> - Room <?= htmlspecialchars($room['room_number']) ?> 
                    (<?= $room['capacity'] - $room['current_occupancy'] ?> beds available, <?= $room['hostel_type'] ?>)
                </option>
            <?php endforeach; ?>
        </select>
    </div>
    
    <div class="row">
        <div class="col-md-6 mb-3">
            <label>Admission Date <span class="text-danger">*</span></label>
            <input type="date" name="admission_date" class="form-control" value="<?= date('Y-m-d') ?>" required>
        </div>
        <div class="col-md-6 mb-3">
            <label>Boarding Type <span class="text-danger">*</span></label>
            <select name="boarding_type" class="form-select" required>
                <option value="Full Boarding">Full Boarding</option>
                <option value="Weekly Boarding">Weekly Boarding</option>
                <option value="Day Scholar">Day Scholar</option>
            </select>
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-6 mb-3">
            <label>Monthly Fee <span class="text-danger">*</span></label>
            <input type="number" step="0.01" name="monthly_fee" class="form-control" required>
        </div>
        <div class="col-md-6 mb-3">
            <label>Status</label>
            <select name="status" class="form-select">
                <option value="1">Active</option>
                <option value="0">Inactive</option>
            </select>
        </div>
    </div>
    
    <div class="mb-3">
        <label>Remarks</label>
        <textarea name="remarks" class="form-control" rows="2"></textarea>
    </div>
    
    <button type="submit" class="btn btn-success">Assign Student</button>
    <a href="/sms/public/boarding/students" class="btn btn-secondary">Cancel</a>
</form>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>