<?php 
$page_title = "Take Attendance";
require_once __DIR__ . '/../includes/header.php'; 
?>

<h2><i class="bi bi-pencil"></i> Take Attendance</h2>
<form method="POST" action="/sms/public/attendance/store" class="card p-4">
    <input type="hidden" name="csrf_token" value="<?= Auth::csrfToken() ?>">
    
    <div class="row mb-3">
        <div class="col-md-6">
            <label>Date</label>
            <input type="date" name="date" class="form-control" value="<?= $date ?>" readonly>
        </div>
        <div class="col-md-6">
            <label>Class</label>
            <input type="text" class="form-control" value="Class <?= $class_id ?>" readonly>
        </div>
    </div>
    
    <table class="table table-hover">
        <thead>
            <tr>
                <th>Admission</th>
                <th>Name</th>
                <th>Status</th>
                <th>Remarks</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($students as $student): 
                $existing = array_filter($attendance, fn($a) => $a['student_id'] == $student['id']);
                $existing = reset($existing);
            ?>
            <tr>
                <td>
                    <?= htmlspecialchars($student['admission_no']) ?>
                    <input type="hidden" name="student_id[]" value="<?= $student['id'] ?>">
                </td>
                <td><?= htmlspecialchars($student['first_name'] . ' ' . $student['last_name']) ?></td>
                <td>
                    <select name="status[]" class="form-select form-select-sm">
                        <option value="Present" <?= ($existing['status'] ?? '') == 'Present' ? 'selected' : '' ?>>Present</option>
                        <option value="Absent" <?= ($existing['status'] ?? '') == 'Absent' ? 'selected' : '' ?>>Absent</option>
                        <option value="Late" <?= ($existing['status'] ?? '') == 'Late' ? 'selected' : '' ?>>Late</option>
                        <option value="Excused" <?= ($existing['status'] ?? '') == 'Excused' ? 'selected' : '' ?>>Excused</option>
                    </select>
                </td>
                <td>
                    <input type="text" name="remarks[]" class="form-control form-control-sm" 
                           value="<?= htmlspecialchars($existing['remarks'] ?? '') ?>">
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    
    <button type="submit" class="btn btn-success">Save Attendance</button>
    <a href="/sms/public/attendance/index" class="btn btn-secondary">Cancel</a>
</form>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>