<?php 
$page_title = "Select Class";
require_once __DIR__ . '/../includes/header.php'; 
?>

<h2><i class="bi bi-calendar-check"></i> Select Class for Attendance</h2>
<div class="row">
    <?php foreach ($classes as $class): ?>
    <div class="col-md-4 mb-4">
        <div class="card shadow h-100">
            <div class="card-body text-center">
                <h4><?= htmlspecialchars($class['name']) ?> - <?= htmlspecialchars($class['section']) ?></h4>
                <a href="/sms/public/attendance/take?class=<?= $class['id'] ?>" class="btn btn-primary">
                    <i class="bi bi-pencil"></i> Take Attendance
                </a>
            </div>
        </div>
    </div>
    <?php endforeach; ?>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>