<?php 
$page_title = "Attendance Report";
require_once __DIR__ . '/../includes/header.php'; 
?>

<h2><i class="bi bi-file-earmark-bar-graph"></i> Attendance Report</h2>
<form method="GET" class="card p-4 mb-4">
    <div class="row">
        <div class="col-md-4">
            <label>Select Student</label>
            <select name="student_id" class="form-select" required>
                <option value="">-- Select Student --</option>
                <?php foreach ($students as $student): ?>
                    <option value="<?= $student['id'] ?>"><?= $student['admission_no'] ?> - <?= $student['first_name'] ?> <?= $student['last_name'] ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="col-md-3">
            <label>From Date</label>
            <input type="date" name="start_date" class="form-control">
        </div>
        <div class="col-md-3">
            <label>To Date</label>
            <input type="date" name="end_date" class="form-control">
        </div>
        <div class="col-md-2 d-flex align-items-end">
            <button type="submit" class="btn btn-primary w-100">Generate</button>
        </div>
    </div>
</form>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>